import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;

public class LoadSaveManager
{
	private String FileLoadedLast;
	private String FileSavedLast;

	public LoadSaveManager()
	{
		FileLoadedLast = null; // we explicitly expect null here
		FileSavedLast = null; // we explicitly expect null here
	}

	public long GetFileHashCode(String FilePath)
	{
		try (DataInputStream is = new DataInputStream(
			new BufferedInputStream(
				// new InflaterInputStream( // https://www.geeksforgeeks.org/compressing-and-decompressing-files-in-java/ + https://www.tutorialspoint.com/how-to-compress-a-file-in-java
				new FileInputStream(FilePath)
			)
		)) // https://jenkov.com/tutorials/java-exception-handling/try-with-resources.html
		{
			// I just did it like this, testing will show if it works... yep, seems to work

			long HashCode = 0L;
			long NonZeroCharCount = 0;

			byte[] Buffer = new byte[8192];
			int BufferLengthRead;

			while (true)
			{
				BufferLengthRead = is.read(Buffer);
				if (BufferLengthRead > 0)
				{
					for (int m = 0; m < BufferLengthRead; m++)
					{
						HashCode += ((long) (byte) Buffer[m]);
						if (Buffer[m] != '\0')
							NonZeroCharCount++;
					}
				}
				else
					break;
			}

			HashCode = (NonZeroCharCount << 32) + (HashCode & 0x00000000FFFFFFFFL);

			is.close();

			return HashCode;
		}
		catch (Exception e)
		{
			System.out.println("error in LoadSaveManager.GetFileHashCode(): " + e.getMessage());

			return 0L;
		}
	}

	public String GetFileLoadedLast()
	{
		return FileLoadedLast;
	}

	public String GetOverrideFileName() // might return null! Caller must handle that!
	{ // file name from path the user saves to with F4

		String OverridePath = GetOverridePath();

		if (OverridePath != null)
		{
			int LastSlashPos = OverridePath.lastIndexOf("/");
			if (LastSlashPos < 0)
				LastSlashPos = OverridePath.lastIndexOf("\\");
			if (LastSlashPos < 0)
				LastSlashPos = -1;

			return OverridePath.substring(LastSlashPos + 1);
		}
		else
		{
			return null;
		}
	}

	public String GetOverridePath() // might return null! Caller must handle that!
	{ // path the user saves to with F4

		String OverridePath = FileSavedLast;

		if (OverridePath == null || OverridePath.length() < 1)
		{
			OverridePath = FileLoadedLast;
		}
		if (OverridePath == null || OverridePath.length() < 1)
		{
			OverridePath = null;
		}

		return OverridePath;
	}

	public void ReactOnFileLoaded(String LoadPath, boolean FileContentWasInserted)
	{
		if (FileContentWasInserted)
		{
			// keep FileLoadedLast
		}
		else
		{
			FileLoadedLast = LoadPath;
			FileSavedLast = null; // we loaded a new file, THAT FILE has not been (newly) saved yet
		}
	}

	public void ReactOnFileLoadError()
	{
		FileLoadedLast = null;
		FileSavedLast = null; // don't save crap to the file the user intended to load or edit
	}

	public void ReactOnFileSaved(String SavePath, boolean FileWasOverriddenWithoutPrompt)
	{
		if (FileWasOverriddenWithoutPrompt)
		{
			FileSavedLast = SavePath;
		}
		else
		{
			FileSavedLast = SavePath;
		}
	}
}
